/* speed.c */

/* test the speet of the hard disk by read from the hard disk. */

#include "obdefs.h"
#include "gemdefs.h"
#include "osbind.h"


main(argc, argv)
int argc;
char *argv[];

{

	char *buf;
	int dev;
	long sizleft, nummb; 
	long start, readsiz, dirsect;
	long bufsiz = 250;	/* the max sectors for the hread() */
	unsigned int time1, time2;

	if (argc != 3)	{
		printf("Usage: speed #Mb unit#\n");
		return;
	}
	if ((nummb = ((long)isint(argv[1]) * 2048)) < 0)	{
		printf("The input must be integers.\n");
		return;
	}
	if ((dev = isint(argv[2])) < 0)	{
		printf("The input must be integers.\n");
		return;
	}

	if ((buf = (char *) Malloc(bufsiz*512)) <= 0) {
		printf("no system memory\n");
		return;
	}
	start = 1024;
	printf("%s %d %s", "The sequential reading time for", atoi(argv[1]),
					"Mb is: "); 
	time1 = Tgettime();		/* get the system time */
	sizleft = nummb;
	while (sizleft)	{
		if (sizleft > bufsiz)	{
			readsiz = bufsiz;
		} else {
			readsiz = sizleft;
		}
		if (rdsects(dev, (int)readsiz, buf, start))	{
			printf("read error.\n");
			goto cln;
		}
		sizleft -= readsiz;
		start += readsiz;
	}
	time2 = Tgettime();		/* get the system time */
	conver(time1, time2);


	sizleft = nummb;
	start = 0;
	dirsect = 50;
	printf("%s %d %s", "The imitated real system reading time for", 
						atoi(argv[1]), "Mb is: "); 
	time1 = Tgettime();		/* get the system time */
	while (sizleft)	{
		if (sizleft > bufsiz)	{
			readsiz = bufsiz;
		} else {
			readsiz = sizleft;
		}
		if (rdsects(dev, (int)dirsect, buf, dirsect))	{
			printf("read error.\n");
			goto cln;
		}
		if (rdsects(dev, (int)readsiz, buf, start))	{
			printf("read error.\n");
			goto cln;
		}
		sizleft -= readsiz;
		start += readsiz;
		dirsect -= 2;
		if (!dirsect) dirsect = 50;
	}
	time2 = Tgettime();		/* get the system time */
	conver(time1, time2);
cln:
	Mfree((long)buf);

}



conver(time1, time2)

unsigned int time1, time2;

{

	int seconds1, minutes1;
	int seconds2, minutes2, result;
	long hours1, hours2, totsec1, totsec2;
	char mins[3], secs[3];

	seconds1 = (time1 & 0x001F) << 1;	/* bits 0:4*/
	minutes1 = (time1 >> 5) & 0x3F;		/* bits 5:10 */
	hours1   = (time1 >> 11) & 0x1F;		/* bits 11:15 */

	totsec1 = hours1 * 3600 + minutes1 * 60 + seconds1;

	seconds2 = (time2 & 0x001F) << 1;	/* bits 0:4*/
	minutes2 = (time2 >> 5) & 0x3F;		/* bits 5:10 */
	hours2   = (time2 >> 11) & 0x1F;		/* bits 11:15 */

	totsec2 = hours2 * 3600 + minutes2 * 60 + seconds2;
	result = totsec2 - totsec1;

	printf("%d %s\n", result, "seconds.");
}


isint(input)
char *input;
{

	char *string;

	string = input;
	while (*string)	{
		if (*string < '0' || *string > '9')
			return 0;
		string++;
	}
	return(atoi(input));

}


